VERSION 5.00
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Object = "{852E65AD-72F8-11CF-840E-444553540000}#1.1#0"; "midiio32.ocx"
Begin VB.Form frmserver 
   Caption         =   "tcp server"
   ClientHeight    =   7995
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   5820
   LinkTopic       =   "Form1"
   ScaleHeight     =   7995
   ScaleWidth      =   5820
   StartUpPosition =   3  'Windows Default
   Begin VB.ListBox listMidi 
      Height          =   1035
      ItemData        =   "frmserver.frx":0000
      Left            =   2400
      List            =   "frmserver.frx":0002
      TabIndex        =   13
      Top             =   4800
      Width           =   3255
   End
   Begin VB.CommandButton cmdRecvMidi 
      BackColor       =   &H000000FF&
      Caption         =   "receive midi"
      Height          =   615
      Left            =   4200
      Style           =   1  'Graphical
      TabIndex        =   12
      Tag             =   "0"
      Top             =   6120
      Width           =   1335
   End
   Begin MidiioLib.MIDIOutput MIDIOutput1 
      Left            =   1320
      Top             =   7440
      _Version        =   65537
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      DeviceID        =   -1
      VolumeLeft      =   65535
      VolumeRight     =   65535
   End
   Begin MidiioLib.MIDIInput MIDIInput1 
      Left            =   720
      Top             =   7440
      _Version        =   65537
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      MessageEventEnable=   -1  'True
   End
   Begin MSWinsockLib.Winsock sockListen 
      Left            =   120
      Top             =   7440
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin VB.Frame connection 
      BackColor       =   &H00C0FFFF&
      Caption         =   "connection"
      Height          =   4695
      Index           =   0
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   4215
      Begin VB.TextBox txtLogtimeout 
         Height          =   375
         Index           =   0
         Left            =   3240
         TabIndex        =   9
         Top             =   1800
         Width           =   615
      End
      Begin VB.Timer timerLogin 
         Enabled         =   0   'False
         Index           =   0
         Interval        =   1000
         Left            =   2160
         Top             =   2160
      End
      Begin VB.ListBox listIn 
         Height          =   840
         Index           =   0
         ItemData        =   "frmserver.frx":0004
         Left            =   240
         List            =   "frmserver.frx":0006
         TabIndex        =   6
         Top             =   360
         Width           =   2895
      End
      Begin VB.CommandButton cmdSend 
         Caption         =   "send"
         Height          =   375
         Index           =   0
         Left            =   3240
         TabIndex        =   4
         Top             =   1320
         Width           =   615
      End
      Begin VB.TextBox txtOut 
         Height          =   375
         Index           =   0
         Left            =   240
         TabIndex        =   3
         Top             =   1320
         Width           =   2895
      End
      Begin VB.CommandButton cmdClear 
         Caption         =   "clear"
         Height          =   375
         Index           =   0
         Left            =   3240
         TabIndex        =   2
         Top             =   360
         Width           =   615
      End
      Begin VB.CommandButton cmdclose 
         Caption         =   "close"
         Height          =   375
         Index           =   0
         Left            =   3240
         TabIndex        =   1
         Top             =   840
         Width           =   615
      End
      Begin MSWinsockLib.Winsock Winsock1 
         Index           =   0
         Left            =   2640
         Top             =   1800
         _ExtentX        =   741
         _ExtentY        =   741
         _Version        =   393216
      End
      Begin VB.Timer timerTcpStatus 
         Index           =   0
         Interval        =   2000
         Left            =   2160
         Top             =   1800
      End
      Begin VB.Label lblLink 
         Caption         =   "link"
         Height          =   255
         Index           =   0
         Left            =   1800
         TabIndex        =   11
         Top             =   1920
         Width           =   255
      End
      Begin VB.Label lblUser 
         Caption         =   "user"
         Height          =   255
         Index           =   0
         Left            =   2640
         TabIndex        =   10
         Top             =   2280
         Width           =   1215
      End
      Begin VB.Label lblIndex 
         Caption         =   "index"
         Height          =   255
         Index           =   0
         Left            =   1200
         TabIndex        =   8
         Top             =   1920
         Width           =   495
      End
      Begin VB.Label lblConnection 
         Caption         =   "connection "
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   7
         Top             =   2280
         Width           =   1935
      End
      Begin VB.Label lblStatus 
         Caption         =   "status"
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   5
         Top             =   1920
         Width           =   855
      End
   End
End
Attribute VB_Name = "frmserver"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False


Const winsockMax = 0  ' maximum number of connections - 1



Private Sub cmdClear_Click(Index As Integer)
    
  
    While listIn(Index).ListCount > 0
        listIn(Index).RemoveItem listIn(Index).ListCount - 1
    Wend
    
    
End Sub

Private Sub cmdclose_Click(Index As Integer)

    Winsock1(Index).Close
    
End Sub

Private Sub cmdRecvMidi_Click()
' turn on or off midi receive mode

    If cmdRecvMidi.Tag = 0 Then
        cmdRecvMidi.Tag = 1
        cmdRecvMidi.BackColor = &HFF00&
        MIDISetupForm.Show vbModal
        MIDIInput1.Action = MIDIIN_START
        MIDIOutput1.Action = MIDIOUT_START
  
    Else
        cmdRecvMidi.Tag = 0
        cmdRecvMidi.BackColor = &HFF&
    End If
    
End Sub

Private Sub cmdSend_Click(Index As Integer)

    Dim i As Integer
    Dim msgstr As String
    
' The TextBox control named txtSendData
' contains the data to be sent. Whenever the user
' clicks the send button, the  string is sent
' using the SendData method.

 
    msgstr = txtOut(Index).Text
    Winsock1(Index).SendData msgstr
    
   
End Sub



Private Sub Form_Load()

   sockListen.LocalPort = 1001 ' set listening port
   sockListen.Listen            ' start listening
   
       
      
End Sub


Private Sub sockListen_ConnectionRequest(ByVal requestID As Long)

' acknowledge incoming requests and establish connection '

    Dim msgstr As String
    Dim i As Integer
    
' find next available socket for the connection by looking through winsock
' array to find a 'closed' connection
'
    For i = 0 To winsockMax
        If Winsock1(i).State = 0 Then   ' if connection is closed
            GoTo assignPort
        End If
    Next i
    
' if you drop through to here, then there are no available ports

    MsgBox "no ports available for connection"
    Exit Sub
   
assignPort:

          
      Winsock1(i).LocalPort = 0 ' forces new random port number
      Winsock1(i).Accept requestID  ' accept connection
      msgstr = CStr(Winsock1(i).RemoteHostIP) + ":" + _
         CStr(Winsock1(i).LocalPort) + ":" + CStr(Winsock1(i).RemotePort)
      lblStatus(i) = "status: " & CStr(Winsock1(i).State)
      lblConnection(i).Caption = msgstr     ' display ip address of client
      timerTcpStatus(i).Enabled = True      ' start the status timer
      connection(i).BackColor = &H80FF80    ' set box to green
      lblIndex(i).Caption = Format(i, "0") ' display index number of connection
      
      lblUser(i).Caption = ""              ' clear some fields
      lblLink(i).Caption = -1              ' no link established
      msgstr = "welcome! please send your user name to login"
      Winsock1(i).SendData msgstr  ' send login message
      
      txtLogtimeout(i).Text = 60  ' start login timeout value
      timerLogin(i).Enabled = True ' start the timer
      
End Sub




Private Sub Text1_Change()

End Sub

Private Sub timerLogin_Timer(Index As Integer)

    txtLogtimeout(Index).Text = Int(txtLogtimeout(Index).Text) - 1 ' countdown - 1
    
    If Int(txtLogtimeout(Index).Text) <= 0 Then ' if timed out
        Winsock1(Index).Close                   ' close the connection
        timerLogin(Index).Enabled = False       ' shut off this timer
    End If

End Sub

Private Sub timerTcpStatus_Timer(Index As Integer)
    
    lblStatus(Index).Caption = Winsock1(Index).State ' display current state
    
    If Winsock1(Index).State = 8 Then ' if closing, then close this end too
        Winsock1(Index).Close
    End If
      
    If Winsock1(Index).State = 0 Then   ' if  closed connection
        connection(Index).BackColor = &HC0FFFF    ' change to yellow
        timerTcpStatus(Index).Enabled = False      ' disable this timer
    End If
    
End Sub

Private Sub winsock1_DataArrival _
(Index As Integer, ByVal bytesTotal As Long)
' Declare a variable for the incoming data.
' Invoke the GetData method and set the Text
' property of a TextBox named txtOutput to
' the data.
Dim strdata As String
Dim cmdstr                  ' command string for client commands
Dim msgstr As String
Dim n As Integer
Dim line          ' break incoming data into separate commands

Winsock1(Index).GetData strdata


' parse commands

cmdstr = Split(strdata) ' split command into tokens

' display all incoming data except midi data

If cmdstr(0) <> "midi" Then
    listIn(Index).AddItem strdata
    listIn(Index).ListIndex = listIn(Index).ListCount - 1 ' move to end of list
End If

' login check

If timerLogin(Index).Enabled = True Then
    lblUser(Index).Caption = strdata    ' get the login name and display
    timerLogin(Index).Enabled = False   ' disable the login timeout timer
    msgstr = "good morning " & strdata
    Winsock1(Index).SendData msgstr  ' send login message
    Exit Sub
End If



' MsgBox ":" & cmdstr(0) & ":"

If cmdstr(0) = "who" Then
    cmdWho Index, strdata
ElseIf cmdstr(0) = "midi" Then
    cmdMidi strdata
ElseIf cmdstr(0) = "help" Then
    cmdHelp Index, strdata
ElseIf cmdstr(0) = "link" Then
    cmdLink Index, strdata
ElseIf lblLink(Index).Caption <> -1 Then
    n = Int(lblLink(Index).Caption)
    If Winsock1(n).State = 7 Then   ' if still connected, send link data
        msgstr = lblUser(Index).Caption & ":" & strdata
        Winsock1(n).SendData msgstr
    Else                             ' otherwise, shut off the link
        lblLink(Index).Caption = CStr(-1)
    End If
End If


End Sub

Private Sub cmdWho(Index As Integer, cmdstr As String)

    Dim i As Integer
    Dim msgstr As String
    
    
'     MsgBox ":" & cmdstr & ":"
    
    For i = 0 To winsockMax
    
        If Winsock1(i).State = 7 Then                   ' if logged in
          msgstr = lblUser(i).Caption & ":" & CStr(i) & CStr(Chr(13))  ' send name of user
          Winsock1(Index).SendData msgstr
          
        End If
    Next i
    
        
            
End Sub


Private Sub cmdHelp(Index As Integer, cmdstr As String)
    Winsock1(Index).SendData "sorry, no help is available"
End Sub

Private Sub cmdLink(Index As Integer, cmdstr As String)

Dim tokens
Dim n As Integer

tokens = Split(cmdstr)

If UBound(tokens) > 0 Then
    If IsNumeric(tokens(1)) Then
        n = Int(tokens(1))
        If n <= winsockMax Then
            If Winsock1(n).State = 7 Then
                lblLink(Index).Caption = CStr(n)
                lblLink(n).Caption = CStr(Index)
            End If
        End If
    End If
End If


End Sub







' this is code to just
' do an echo thing

Sub MIDIInput1_Message()
   Dim InMessage As Integer
   Dim InData1 As Integer
   Dim InData2 As Integer
   Dim Y As Integer

     'This do while loop allows you to take all the messages that are
   'waiting in the message queue.
   '
   Do While MIDIInput1.MessageCount > 0
      '
      'This is the incoming MIDI data
      '
      InMessage = MIDIInput1.message
      InData1 = MIDIInput1.data1
      InData2 = MIDIInput1.data2
      

' display the data in text boxes
'
    message.Text = InMessage
    data1.Text = InData1
    data2.Text = InData2
    
'
'Tell MIDIOutput1 to send the MIDI data
'

         MIDIOutput1.message = InMessage
         MIDIOutput1.data1 = InData1
         MIDIOutput1.data2 = InData2
         MIDIOutput1.Action = MIDIOUT_SEND
 

   
      '
      'Remove the MIDI data from the MIDI IN queue
      '
      MIDIInput1.Action = MIDIIN_REMOVE
      

    
   Loop
End Sub

Private Sub Form_Unload(Cancel As Integer)
    ' Stop the MIDI In
    If (MIDIInput1.State <> 0) And (MIDIInput1.State <> 1) Then
        MIDIInput1.Action = MIDIIN_STOP
        End If
    
    ' Close MIDI In
    If (MIDIInput1.State <> 0) Then
        MIDIInput1.Action = MIDIIN_CLOSE
        End If
    
    ' Close MIDI Out
    MIDIOutput1.Action = MIDIOUT_CLOSE

    End
End Sub


Private Sub MIDIInput1_Error(ErrorCode As Integer, ErrorMessage As String)
    '
    ' Midi input error, display message
    '
   If (ErrorCode <> 0) And (ErrorCode <> 8) Then
      MsgBox ErrorMessage
      End If
End Sub



Private Sub MIDIOutput1_Error(ErrorCode As Integer, ErrorMessage As String)
    '
    ' Midi output error, display message
    '
   If (ErrorCode <> 0) And (ErrorCode <> 8) Then
      MsgBox ErrorMessage
      End If
End Sub

Private Sub cmdMidi(strdata As String)
' process incoming midi data

Dim line    ' for multiple lines of data
Dim i As Integer
Dim token

line = Split(strdata, CStr(Chr(13)))


For i = 0 To UBound(line)
    
    listMidi.AddItem line(i)
    listMidi.ListIndex = listMidi.ListCount - 1
    
    
    token = Split(line(i))      ' split the line into messages
    
    If UBound(token) >= 0 Then   ' if not totally blank '
    
    If cmdRecvMidi.Tag = 1 And token(0) = "midi" Then
        If UBound(token) >= 3 Then
            MIDIOutput1.data2 = token(3)
        End If
        If UBound(token) >= 2 Then
            MIDIOutput1.data1 = token(2)
        End If
        If UBound(token) >= 1 Then
            MIDIOutput1.message = token(1)
            MIDIOutput1.Action = MIDIOUT_SEND
        End If
    End If
    End If
    
 
 Next i
 
End Sub
